<?php
session_start();
if (!isset($_SESSION['id_usuario'])) {
    header("Location: login.php");
    exit;
}
require 'db.php';
?>
<!DOCTYPE html>
<html lang="es">
<head>
  <meta charset="UTF-8">
  <title>Recepción de Materiales</title>
  <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
  <style>
    body {
      font-family: 'Segoe UI', sans-serif;
      background-color: #f4fff6;
      padding: 30px;
    }
    .container {
      max-width: 1100px;
      margin: auto;
      background: #fff;
      padding: 25px;
      border-radius: 10px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    h2 {
      text-align: center;
      color: #2e7d32;
      margin-bottom: 20px;
    }
    fieldset {
      border: 1px solid #ccc;
      padding: 15px;
      margin-bottom: 20px;
      border-radius: 6px;
    }
    legend {
      font-weight: bold;
      color: #2e7d32;
    }
    label {
      display: block;
      margin-top: 10px;
      font-weight: 500;
    }
    input, select, textarea {
      width: 100%;
      padding: 8px;
      margin-top: 5px;
      border-radius: 5px;
      border: 1px solid #ccc;
    }
    .row {
      display: flex;
      flex-wrap: wrap;
      gap: 20px;
    }
    .col-6 { width: 48%; }
    .boton {
      background-color: #2e7d32;
      color: white;
      padding: 10px 20px;
      border: none;
      border-radius: 5px;
      cursor: pointer;
      margin-top: 20px;
    }
    .boton:hover {
      background-color: #1b5e20;
    }
    table {
      width: 100%;
      border-collapse: collapse;
      margin-top: 20px;
    }
    th, td {
      border: 1px solid #ccc;
      padding: 8px;
      text-align: left;
    }
    th {
      background-color: #e8f5e9;
      color: #2e7d32;
    }
    table input, table select {
      padding: 5px;
      font-size: 13px;
    }
    td input, td select {
      width: 100px;
      max-width: 100px;
    }
    td select.select-producto {
      width: 180px !important;
      max-width: 180px;
    }
    textarea { resize: vertical; }
  </style>
</head>
<body>
<div class="container">
  <h2>Recepción de Materiales</h2>
  <form method="post" action="procesar_recepcion.php">

    <!-- Proveedor -->
    <fieldset>
      <legend>Proveedor</legend>
      <div class="row">
        <div class="col-6">
          <label for="proveedor">Razón Social:</label>
          <select id="proveedor" name="rif_proveedor" required>
            <option value="">-- Seleccione proveedor --</option>
            <?php
            $res = $conn->query("SELECT cedula, razon_social FROM proveedor ORDER BY razon_social ASC");
            while ($prov = $res->fetch_assoc()):
            ?>
              <option value="<?= $prov['cedula'] ?>"><?= htmlspecialchars($prov['razon_social']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="col-6">
          <label for="cedula_proveedor">RIF / Cédula:</label>
          <input type="text" name="cedula_proveedor" id="cedula_proveedor" readonly>
        </div>
        <div class="col-6">
          <label for="direccion_proveedor">Dirección:</label>
          <input type="text" name="direccion_proveedor" id="direccion_proveedor" readonly>
        </div>
        <div class="col-6">
          <label for="contacto_proveedor">Persona Contacto:</label>
          <input type="text" name="contacto_proveedor" id="contacto_proveedor" readonly>
        </div>
        <div class="col-6">
          <label for="doc_referencia">Doc. Referencia:</label>
          <input type="text" name="doc_referencia" id="doc_referencia" placeholder="Ej: Factura 001234" required>
        </div>
        <div class="col-6">
          <label for="guia_sada">Guía SADA:</label>
          <input type="text" name="guia_sada" id="guia_sada" placeholder="Ej: G-456789" required>
        </div>
      </div>
    </fieldset>

    <!-- Transporte -->
    <fieldset>
      <legend>Transporte</legend>
      <div class="row">
        <div class="col-6">
          <label for="razon_transporte">Razón Social Transporte:</label>
          <select id="razon_transporte" name="razon_transporte" required>
            <option value="">-- Seleccione empresa transporte --</option>
            <?php
            $empresas = $conn->query("SELECT DISTINCT razon_social FROM transporte ORDER BY razon_social ASC");
            while ($row = $empresas->fetch_assoc()):
            ?>
              <option value="<?= htmlspecialchars($row['razon_social']) ?>"><?= htmlspecialchars($row['razon_social']) ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="col-6">
          <label for="chofer">Chofer:</label>
          <select id="chofer" name="chofer" required>
            <option value="">-- Seleccione chofer --</option>
          </select>
        </div>
        <div class="col-6">
          <label for="vehiculo">Vehículo:</label>
          <select id="vehiculo" name="vehiculo" required>
            <option value="">-- Vehículo asignado --</option>
          </select>
        </div>
        <div class="col-6">
          <label for="placa_chuto">Placa Chuto:</label>
          <select name="placa_chuto" id="placa_chuto" required>
            <option value="">-- Seleccione placa chuto --</option>
          </select>
        </div><div class="col-6">
  <label for="placa_batea">Placa Batea:</label>
  <select name="placa_batea" id="placa_batea" required>
    <option value="">-- Seleccione placa batea --</option>
  </select>
</div>


      </div>
    </fieldset>

    <!-- Almacén y observaciones -->
    <div class="row">
      <div class="col-6">
        <label for="almacen">Almacén de Resguardo:</label>
        <select name="almacen" id="almacen" required>
          <option value="">Seleccione</option>
          <?php
          $alm = $conn->query("SELECT descripcion FROM almacenes ORDER BY descripcion ASC");
          while ($a = $alm->fetch_assoc()):
          ?>
            <option value="<?= $a['descripcion'] ?>"><?= htmlspecialchars($a['descripcion']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-6">
        <label for="observaciones">Observaciones:</label>
        <textarea name="observaciones" id="observaciones" rows="2"></textarea>
      </div>
    </div>

    <!-- Detalle de Productos -->
    <h3>Detalle de Productos</h3>
    <table>
      <thead>
        <tr>
          <th>Código</th>
          <th>Descripción</th>
          <th>Presentación</th>
          <th>Cantidad</th>
          <th>Peso Bruto</th>
          <th>Peso Tara</th>
          <th>Peso Neto</th>
          <th>Agregar</th>
        </tr>
      </thead>
      <tbody id="tabla-productos">
        <tr>
          <td><input type="text" name="codigo[]" class="codigo" readonly></td>
          <td>
            <select name="descripcion[]" class="select-producto descripcion" required>
              <option value="">-- Buscar producto --</option>
              <?php
              $res = $conn->query("SELECT * FROM productos ORDER BY descripcion ASC");
              while ($p = $res->fetch_assoc()):
              ?>
                <option value="<?= htmlspecialchars($p['descripcion']) ?>" 
                        data-codigo="<?= $p['codigo'] ?>" 
                        data-categoria="<?= $p['categoria'] ?>" 
                        data-presentacion="<?= $p['presentacion'] ?>">
                  <?= htmlspecialchars($p['descripcion']) ?>
                </option>
              <?php endwhile; ?>
            </select>
           </td>
  <td><input type="text" name="presentacion[]" class="presentacion" readonly></td>
  <td><input type="text" name="cantidad[]" class="cantidad"></td>
  <td><input type="text" name="peso_bruto[]" class="bruto"></td>
  <td><input type="text" name="peso_tara[]" class="tara"></td>
  <td><input type="text" name="peso_neto[]" class="neto" readonly></td>
  <td>
  <button type="button" onclick="agregarFila()">➕</button>
  <button type="button" class="eliminar-fila">🗑️</button>
</td>

</tr>
      </tbody>
    </table>

    <div style="margin-top:30px; text-align:center;">
      <button type="submit" class="boton">Guardar Recepción</button>
      <a href="home.php" class="boton" style="background:#555;">⬅ Volver</a>
    </div>
  </form>
</div>

<!-- Scripts -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function () {
  $('#proveedor, #razon_transporte, #chofer, .select-producto').select2();

  $('#proveedor').on('change', function () {
    let rif = $(this).val();
    if (!rif) return;
    $.post("consultar_proveedor.php", { rif: rif }, function (response) {
      if (response.success) {
        $('#cedula_proveedor').val(response.data.cedula);
        $('#direccion_proveedor').val(response.data.direccion);
        $('#contacto_proveedor').val(response.data.persona_contacto);
      }
    }, 'json');
  });

  $('#razon_transporte').on('change', function () {
    let razon = $(this).val();
    if (!razon) return;
    $.post("consultar_transportes.php", { razon_social: razon }, function (response) {
      if (response.success) {
        $('#chofer').empty().append('<option value="">-- Seleccione chofer --</option>');
        $('#vehiculo').empty().append('<option value="">-- Vehículo asignado --</option>');
        $('#placa_chuto').empty().append('<option value="">-- Seleccione placa chuto --</option>');
        response.choferes.forEach(ch => {
          $('#chofer').append(`<option value="${ch}">${ch}</option>`);
        });
        response.vehiculos.forEach(v => {
          $('#vehiculo').append(`<option value="${v}">${v}</option>`);
        });
      }
    }, 'json');
  });

  $('#chofer').on('change', function () {
    let razon = $('#razon_transporte').val();
    let chofer = $(this).val();
    if (!razon || !chofer) return;
    $.post("consultar_chofer.php", { razon_social: razon, chofer: chofer }, function (response) {
      if (response.success) {
        $('#vehiculo').empty().append(`<option value="${response.data.vehiculo}">${response.data.vehiculo}</option>`);
        $('#vehiculo').val(response.data.vehiculo);
        $('#placa_chuto').empty().append(`<option value="${response.data.placa_chuto}">${response.data.placa_chuto}</option>`);
        $('#placa_batea').val(response.data.placa_batea || '');
      }
    }, 'json');
  });

  // Cuando se selecciona el vehículo, consultar las placas chuto y batea
$('#vehiculo').on('change', function () {
  const razon = $('#razon_transporte').val();
  const vehiculo = $(this).val();

  if (!razon || !vehiculo) return;

  $.post("consultar_placas.php", {
    razon_social: razon,
    vehiculo: vehiculo
  }, function (response) {
    if (response.success) {
      $('#placa_chuto').empty().append('<option value="">-- Seleccione placa chuto --</option>');

      response.placas_chuto.forEach(function (placa) {
        $('#placa_chuto').append(`<option value="${placa}">${placa}</option>`);
      });

     $('#placa_batea').empty().append('<option value="">-- Seleccione placa batea --</option>');
response.placas_batea.forEach(function (placa) {
  $('#placa_batea').append(`<option value="${placa}">${placa}</option>`);
});

    } else {
      console.warn("No se encontraron placas.");
    }
  }, 'json');
});


  $(document).on('change', '.select-producto', function () {
    const selected = $(this).find('option:selected');
    const row = $(this).closest('tr');
    row.find('.codigo').val(selected.data('codigo') || '');
    row.find('.presentacion').val(selected.data('presentacion') || '');
  });

  
});


function agregarFila() {
  const fila = $('#tabla-productos tr:first').clone();
  fila.find('input').val('');
  fila.find('select').val('').trigger('change');
  $('#tabla-productos').append(fila);
  fila.find('.select-producto').select2();
}

// Eliminar fila de producto
$(document).on('click', '.eliminar-fila', function () {
  const totalFilas = $('#tabla-productos tr').length;
  if (totalFilas > 1) {
    $(this).closest('tr').remove();
  } else {
    alert('Debe haber al menos una fila en la tabla.');
  }
});


</script>
<script>
function formatearMilesDecimal(input) {
  let valor = input.value.replace(/\./g, '').replace(',', '.');
  if (!isNaN(valor) && valor !== '') {
    let numero = parseFloat(valor).toFixed(2);
    input.value = new Intl.NumberFormat('es-VE', {
      minimumFractionDigits: 2,
      maximumFractionDigits: 2
    }).format(numero);
  }
}

// Aplicar formato al salir de los campos numéricos
$(document).on('blur', '.cantidad, .bruto, .tara, .neto', function () {
  formatearMilesDecimal(this);
});

// Calcular y formatear peso neto automáticamente
$(document).on('input', '.bruto, .tara', function () {
  const row = $(this).closest('tr');

  const brutoStr = row.find('.bruto').val().replace(/\./g, '').replace(',', '.');
  const taraStr = row.find('.tara').val().replace(/\./g, '').replace(',', '.');

  const bruto = parseFloat(brutoStr) || 0;
  const tara = parseFloat(taraStr) || 0;

  const neto = bruto - tara;

  if (neto >= 0) {
    row.find('.neto').val(
      new Intl.NumberFormat('es-VE', {
        minimumFractionDigits: 2,
        maximumFractionDigits: 2
      }).format(neto)
    );
  } else {
    row.find('.neto').val('0,00');
  }
});

</script>

</body>
</html>
